import { BinaryParser } from '../serdes/binary-parser';
import { JsonObject, SerializedType } from './serialized-type';
interface XRPIssue extends JsonObject {
    currency: string;
}
interface IOUIssue extends JsonObject {
    currency: string;
    issuer: string;
}
interface MPTIssue extends JsonObject {
    mpt_issuance_id: string;
}
/**
 * Interface for JSON objects that represent issues
 */
type IssueObject = XRPIssue | IOUIssue | MPTIssue;
/**
 * Class for serializing/Deserializing Amounts
 */
declare class Issue extends SerializedType {
    static readonly ZERO_ISSUED_CURRENCY: Issue;
    constructor(bytes: Uint8Array);
    /**
     * Construct an amount from an IOU or string amount
     *
     * @param value An Amount, object representing an IOU, MPTAmount, or a string
     *     representing an integer amount
     * @returns An Issue object
     */
    static from<T extends Issue | IssueObject>(value: T): Issue;
    /**
     * Read an amount from a BinaryParser
     *
     * @param parser BinaryParser to read the Amount from
     * @param hint The number of bytes to consume from the parser.
     * For an MPT amount, pass 24 (the fixed length for Hash192).
     *
     * @returns An Issue object
     */
    static fromParser(parser: BinaryParser, hint?: number): Issue;
    /**
     * Get the JSON representation of this Amount
     *
     * @returns the JSON interpretation of this.bytes
     */
    toJSON(): IssueObject;
}
export { Issue, IssueObject };
