/*
 * Decompiled with CFR 0.152.
 */
package com.jarego.jayatana.swing;

import com.jarego.jayatana.Feature;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;

public class SwingGTKFixed
implements Feature,
PropertyChangeListener {
    @Override
    public void deploy() {
        UIManager.addPropertyChangeListener(new SwingGTKFixed());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lookAndFeel".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue().getClass().getName().contains("GTKLookAndFeel")) {
            try {
                SwingGTKFixed.installGtkThikcness();
            }
            catch (Exception e) {
                Logger.getLogger(SwingGTKFixed.class.getName()).log(Level.WARNING, "can't install gtk border fixed", e);
            }
        }
    }

    private static void installGtkThikcness() throws Exception {
        JComponent comp = new JComponent(){};
        SwingGTKFixed.changeGtkYThikcness(GTKLookAndFeel.getStyle(comp, Region.POPUP_MENU), 1);
        SwingGTKFixed.changeGtkXThikcness(GTKLookAndFeel.getStyle(comp, Region.POPUP_MENU), 1);
        SwingGTKFixed.changeGtkYThikcness(GTKLookAndFeel.getStyle(comp, Region.POPUP_MENU_SEPARATOR), 1);
    }

    private static void changeGtkYThikcness(Object style, int border) throws Exception {
        Field field = style.getClass().getDeclaredField("yThickness");
        field.setAccessible(true);
        field.setInt(style, Math.max(border, field.getInt(style)));
        field.setAccessible(false);
    }

    private static void changeGtkXThikcness(Object style, int border) throws Exception {
        Field field = style.getClass().getDeclaredField("xThickness");
        field.setAccessible(true);
        field.setInt(style, Math.max(border, field.getInt(style)));
        field.setAccessible(false);
    }
}

