/*
 * Decompiled with CFR 0.152.
 */
package com.jarego.jayatana.swing;

import com.jarego.jayatana.basic.GlobalMenuAdapter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.FocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SwingGlobalMenuWindow
extends GlobalMenuAdapter
implements WindowListener,
AWTEventListener,
ContainerListener,
PropertyChangeListener,
ComponentListener {
    private JMenuBar menubar;
    private boolean netbeansPlatform;
    private boolean fullscreen = false;

    public SwingGlobalMenuWindow(Window window, JMenuBar menubar) {
        super(window);
        this.menubar = menubar;
    }

    @Override
    protected void register(final int state) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (state == 0) {
                        SwingGlobalMenuWindow.this.menubar.setVisible(false);
                        SwingGlobalMenuWindow.this.netbeansPlatform = "org.openide.awt.MenuBar".equals(SwingGlobalMenuWindow.this.menubar.getClass().getName());
                        for (Component comp : SwingGlobalMenuWindow.this.menubar.getComponents()) {
                            if (!(comp instanceof JMenu)) continue;
                            ((JMenu)comp).addPropertyChangeListener(SwingGlobalMenuWindow.this);
                            ((JMenu)comp).addComponentListener(SwingGlobalMenuWindow.this);
                        }
                        SwingGlobalMenuWindow.this.menubar.addContainerListener(SwingGlobalMenuWindow.this);
                        Toolkit.getDefaultToolkit().addAWTEventListener(SwingGlobalMenuWindow.this, 8L);
                        ((Window)SwingGlobalMenuWindow.this.getWindow()).addWindowListener(SwingGlobalMenuWindow.this);
                        ((Window)SwingGlobalMenuWindow.this.getWindow()).addComponentListener(SwingGlobalMenuWindow.this);
                    }
                    SwingGlobalMenuWindow.this.createMenuBarMenus();
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected void unregister() {
        ((Window)this.getWindow()).removeWindowListener(this);
        ((Window)this.getWindow()).addComponentListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        for (Component comp : this.menubar.getComponents()) {
            if (!(comp instanceof JMenu)) continue;
            ((JMenu)comp).removePropertyChangeListener(this);
            ((JMenu)comp).removeComponentListener(this);
        }
        this.menubar.removeContainerListener(this);
        this.menubar.setVisible(true);
    }

    private void createMenuBarMenus() {
        for (Component comp : this.menubar.getComponents()) {
            if (!(comp instanceof JMenu)) continue;
            this.addMenu(null, (JMenu)comp);
        }
    }

    private void addMenu(JMenu parent, JMenu menu) {
        if (parent == null) {
            this.addMenu(menu.hashCode(), menu.getText(), menu.isEnabled(), menu.isVisible());
        } else {
            this.addMenu(parent.hashCode(), menu.hashCode(), menu.getText(), menu.isEnabled(), menu.isVisible());
        }
    }

    private void addMenuItem(JMenu parent, JMenuItem menuitem) {
        Dimension size = menuitem.getPreferredSize();
        if (size.height < 2) {
            return;
        }
        int modifiers = -1;
        int keycode = -1;
        if (menuitem.getAccelerator() != null) {
            modifiers = menuitem.getAccelerator().getModifiers();
            keycode = menuitem.getAccelerator().getKeyCode();
        }
        if (menuitem instanceof JRadioButtonMenuItem) {
            this.addMenuItemRadio(parent.hashCode(), menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else if (menuitem instanceof JCheckBoxMenuItem) {
            this.addMenuItemCheck(parent.hashCode(), menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else {
            this.addMenuItem(parent.hashCode(), menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode);
        }
    }

    private JMenuItem getJMenuItem(int hashcode) {
        for (Component comp : this.menubar.getComponents()) {
            JMenuItem item;
            if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
            return item;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem menu, int hashcode) {
        if (menu.hashCode() == hashcode) {
            return menu;
        }
        if (menu instanceof JMenu) {
            for (Component comp : ((JMenu)menu).getMenuComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    protected void menuActivated(int parentMenuId, int menuId) {
        final JMenuItem menuitem = this.getJMenuItem(menuId);
        if (menuitem != null && menuitem.isEnabled() && menuitem.isVisible()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    menuitem.getModel().setArmed(true);
                    menuitem.getModel().setPressed(true);
                    menuitem.getModel().setPressed(false);
                    menuitem.getModel().setArmed(false);
                }
            });
        }
    }

    private boolean isInstanceReflection(Class<?> cls, String scls) {
        if ("java.lang.Object".equals(cls.getName())) {
            return false;
        }
        if (scls.equals(cls.getName())) {
            return true;
        }
        for (Class<?> clsInterface : cls.getInterfaces()) {
            if (!scls.equals(clsInterface.getName())) continue;
            return true;
        }
        return this.isInstanceReflection(cls.getSuperclass(), scls);
    }

    private void menuAboutToShowForNetbeansPlatform(JMenu menu) {
        if (this.isInstanceReflection(menu.getClass(), "org.openide.awt.MenuBar$LazyMenu")) {
            try {
                Field fieldDynaModel;
                Method methodDoInitialize = menu.getClass().getDeclaredMethod("doInitialize", new Class[0]);
                if (!methodDoInitialize.isAccessible()) {
                    methodDoInitialize.setAccessible(true);
                }
                if (!(fieldDynaModel = menu.getClass().getDeclaredField("dynaModel")).isAccessible()) {
                    fieldDynaModel.setAccessible(true);
                }
                Class<?> classDynaModel = fieldDynaModel.getType();
                Method methodDynaModel = classDynaModel.getMethod("checkSubmenu", JMenu.class);
                if (!methodDynaModel.isAccessible()) {
                    methodDynaModel.setAccessible(true);
                }
                methodDoInitialize.invoke((Object)menu, new Object[0]);
                Object objectDynaModel = fieldDynaModel.get(menu);
                methodDynaModel.invoke(objectDynaModel, menu);
            }
            catch (Exception e) {
                Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.isInstanceReflection(menu.getClass(), "org.openide.awt.DynamicMenuContent")) {
            try {
                Method methodSynchMenu = menu.getClass().getDeclaredMethod("synchMenuPresenters", JComponent[].class);
                if (!methodSynchMenu.isAccessible()) {
                    methodSynchMenu.setAccessible(true);
                }
                methodSynchMenu.invoke((Object)menu, new Object[]{null});
            }
            catch (Exception e) {
                Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void menuAboutToShow(int parentMenuId, final int menuId) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JMenu menu = (JMenu)SwingGlobalMenuWindow.this.getJMenuItem(menuId);
                    int items = 0;
                    if (menu != null && menu.isEnabled() && menu.isVisible()) {
                        menu.getModel().setSelected(true);
                        JPopupMenu popupMenu = menu.getPopupMenu();
                        PopupMenuEvent pevent = new PopupMenuEvent(popupMenu);
                        for (PopupMenuListener pl : popupMenu.getPopupMenuListeners()) {
                            if (pl == null) continue;
                            pl.popupMenuWillBecomeVisible(pevent);
                        }
                        if (SwingGlobalMenuWindow.this.netbeansPlatform) {
                            SwingGlobalMenuWindow.this.menuAboutToShowForNetbeansPlatform(menu);
                        }
                        for (Component comp : popupMenu.getComponents()) {
                            if (comp instanceof JMenu) {
                                SwingGlobalMenuWindow.this.addMenu(menu, (JMenu)comp);
                                ++items;
                                continue;
                            }
                            if (comp instanceof JMenuItem && comp.isVisible()) {
                                SwingGlobalMenuWindow.this.addMenuItem(menu, (JMenuItem)comp);
                                ++items;
                                continue;
                            }
                            if (!(comp instanceof JSeparator) || !comp.isVisible()) continue;
                            SwingGlobalMenuWindow.this.addSeparator(menu.hashCode());
                            ++items;
                        }
                    }
                    if (items == 0 && menu != null) {
                        SwingGlobalMenuWindow.this.addMenuItem(menu.hashCode(), -1, "(...)", false, -1, -1);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void menuAfterClose(int parentMenuId, final int menuId) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JMenu menu = (JMenu)SwingGlobalMenuWindow.this.getJMenuItem(menuId);
                    if (menu != null && menu.isEnabled() && menu.isVisible()) {
                        JPopupMenu popupMenu = menu.getPopupMenu();
                        if (popupMenu != null) {
                            PopupMenuEvent pevent = new PopupMenuEvent(popupMenu);
                            for (PopupMenuListener pl : popupMenu.getPopupMenuListeners()) {
                                if (pl == null) continue;
                                pl.popupMenuWillBecomeInvisible(pevent);
                            }
                        }
                        menu.getModel().setSelected(false);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.unregisterWatcher();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private Window getWindow(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof JFrame) {
            return (Window)comp;
        }
        if (comp instanceof JDialog) {
            return (Window)comp;
        }
        return this.getWindow(comp.getParent());
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent e = (KeyEvent)event;
        if (e.getID() == 401 && !e.isConsumed() && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 157 && e.getKeyCode() != 65406 && this.getWindow((Component)e.getSource()) == this.getWindow()) {
            try {
                JComponent jcomp;
                KeyStroke acelerator = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                if (FocusManager.getCurrentManager().getFocusOwner() instanceof JComponent && (jcomp = (JComponent)FocusManager.getCurrentManager().getFocusOwner()).getActionForKeyStroke(acelerator) == null) {
                    Object result;
                    Method methodProcessKeyBinding = JMenuBar.class.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                    if (!methodProcessKeyBinding.isAccessible()) {
                        methodProcessKeyBinding.setAccessible(true);
                    }
                    if (Boolean.TRUE.equals(result = methodProcessKeyBinding.invoke((Object)this.menubar, KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()), e, 2, true))) {
                        e.consume();
                    }
                }
            }
            catch (Exception err) {
                Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.WARNING, err.getMessage(), err);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).addPropertyChangeListener(this);
            ((JMenu)e.getChild()).addComponentListener(this);
            this.refreshWatcherSafe();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).removePropertyChangeListener(this);
            ((JMenu)e.getChild()).removeComponentListener(this);
            this.refreshWatcherSafe();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            JMenu menu = (JMenu)evt.getSource();
            this.updateMenu(menu.hashCode(), menu.getText(), menu.isEnabled(), menu.isVisible());
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (e.getSource() instanceof JMenu) {
            JMenu menu = (JMenu)e.getSource();
            this.updateMenu(menu.hashCode(), menu.getText(), menu.isEnabled(), menu.isVisible());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (e.getSource() instanceof JMenu) {
            JMenu menu = (JMenu)e.getSource();
            this.updateMenu(menu.hashCode(), menu.getText(), menu.isEnabled(), menu.isVisible());
        } else if (e.getSource() instanceof Window) {
            this.refreshWatcherSafe();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() instanceof Window) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Point rootPaneLoc = null;
            Dimension rootPaneSize = null;
            if (this.getWindow() instanceof JFrame) {
                rootPaneLoc = ((JFrame)this.getWindow()).getRootPane().getLocationOnScreen();
                rootPaneSize = ((JFrame)this.getWindow()).getRootPane().getSize();
            } else if (this.getWindow() instanceof JDialog) {
                rootPaneLoc = ((JDialog)this.getWindow()).getRootPane().getLocationOnScreen();
                rootPaneSize = ((JDialog)this.getWindow()).getRootPane().getSize();
            }
            if (rootPaneLoc != null && rootPaneSize != null) {
                if (rootPaneSize.height >= screenSize.height && rootPaneSize.width >= screenSize.width && rootPaneLoc.x == 0 && rootPaneLoc.y == 0 && !this.fullscreen) {
                    this.fullscreen = true;
                    this.unregisterWatcher();
                    for (Component comp : this.menubar.getComponents()) {
                        if (!(comp instanceof JMenu)) continue;
                        ((JMenu)comp).getModel().setSelected(false);
                    }
                } else if ((rootPaneSize.height < screenSize.height || rootPaneSize.width < screenSize.width) && rootPaneLoc.x >= 0 && rootPaneLoc.y >= 0 && this.fullscreen) {
                    this.fullscreen = false;
                    this.registerWatcher();
                }
            }
        }
    }
}

